/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.util.ArrayList;
import java.util.List;
import org.python.antlr.ParseException;
import org.python.antlr.Visitor;
import org.python.antlr.ast.Assign;
import org.python.antlr.ast.Name;
import org.python.antlr.ast.Suite;
import org.python.antlr.ast.Tuple;
import org.python.antlr.ast.arguments;
import org.python.antlr.ast.expr_contextType;
import org.python.antlr.base.expr;
import org.python.antlr.base.stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgListCompiler
extends Visitor {
    public boolean arglist = false;
    public boolean keywordlist = false;
    public List<expr> defaults = null;
    public List<String> names = new ArrayList<String>();
    public List<String> fpnames = new ArrayList<String>();
    public List<stmt> init_code = new ArrayList<stmt>();

    public void reset() {
        this.keywordlist = false;
        this.arglist = false;
        this.defaults = null;
        this.names.clear();
        this.init_code.clear();
    }

    public void appendInitCode(Suite suite) {
        suite.getInternalBody().addAll(0, this.init_code);
    }

    public List<expr> getDefaults() {
        return this.defaults;
    }

    public void visitArgs(arguments arguments2) throws Exception {
        int n;
        for (n = 0; n < arguments2.getInternalArgs().size(); ++n) {
            String string = (String)this.visit(arguments2.getInternalArgs().get(n));
            this.names.add(string);
            if (!(arguments2.getInternalArgs().get(n) instanceof Tuple)) continue;
            ArrayList<expr> arrayList = new ArrayList<expr>();
            arrayList.add(arguments2.getInternalArgs().get(n));
            Assign assign = new Assign(arguments2.getInternalArgs().get(n), arrayList, (expr)new Name(arguments2.getInternalArgs().get(n), string, expr_contextType.Load));
            this.init_code.add(assign);
        }
        if (arguments2.getInternalVararg() != null) {
            this.arglist = true;
            this.names.add(arguments2.getInternalVararg());
        }
        if (arguments2.getInternalKwarg() != null) {
            this.keywordlist = true;
            this.names.add(arguments2.getInternalKwarg());
        }
        this.defaults = arguments2.getInternalDefaults();
        for (n = 0; n < this.defaults.size(); ++n) {
            if (this.defaults.get(n) != null) continue;
            throw new ParseException("non-default argument follows default argument", arguments2.getInternalArgs().get(arguments2.getInternalArgs().size() - this.defaults.size() + n));
        }
    }

    @Override
    public Object visitName(Name name) throws Exception {
        if (name.getInternalCtx() != expr_contextType.Store && name.getInternalCtx() != expr_contextType.Param) {
            return null;
        }
        if (this.fpnames.contains(name.getInternalId())) {
            throw new ParseException("duplicate argument name found: " + name.getInternalId(), name);
        }
        this.fpnames.add(name.getInternalId());
        return name.getInternalId();
    }

    @Override
    public Object visitTuple(Tuple tuple) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("(");
        int n = tuple.getInternalElts().size();
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append(this.visit(tuple.getInternalElts().get(i)));
            stringBuffer.append(", ");
        }
        stringBuffer.append(this.visit(tuple.getInternalElts().get(n - 1)));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

